# DO NOT EDIT. THIS FILE IS GENERATED BY THE MAKEFILE.
module "kubernetes" {
  source = "coreos/kubernetes/azurerm"

  // (optional) Azure cloud environment to use. See
  // https://github.com/Azure/go-autorest/blob/ec5f4903f77ed9927ac95b19ab8e44ada64c1356/autorest/azure/environments.go#L13
  // for available environments.
  // tectonic_azure_cloud_environment = "AZUREPUBLICCLOUD"


  // (optional) Storage account type for the etcd node(s). Example: Premium_LRS.
  // Using Premium storage is constrained by the of instance specified in 'tectonic_azure_etcd_vm_size'.
  // See https://docs.microsoft.com/en-us/azure/storage/storage-premium-storage#supported-vms
  // tectonic_azure_etcd_storage_type = "Premium_LRS"


  // (optional) Instance size for the etcd node(s). Example: Standard_DS2_v2.
  // tectonic_azure_etcd_vm_size = "Standard_DS2_v2"


  // (optional) The ID of the external Azure DNS zone used for nodes & endpoints FQDNs.
  // Required when 'tectonic_base_domain' is set.
  // This must be a pre-existing, properly configured Azure DNS zone that the Azure service principal running the Tectonic installer has permission to perform operations on.
  // 
  // Note this is the complete ID as returned in the "id" field by the Azure client, not just the name of the resource.
  // 
  // Example: "/subscriptions/b520eabf-d6c0-4757-8a5e-0fa7d2fe12b5/resourceGroups/my-k8s-cluster/providers/Microsoft.Network/dnszones/my-k8s-dns
  // tectonic_azure_external_dns_zone_id = ""


  // (optional) Subnet ID within an existing VNet to deploy master nodes into.
  // Required to use an existing VNet.
  // 
  // Note this is the complete ID as returned in the "id" field by the Azure client, not just the name of the resource.
  // 
  // Example: "/subscriptions/b520eabf-d6c0-4757-8a5e-0fa7d2fe12b5/resourceGroups/my-k8s-cluster/providers/Microsoft.Network/virtualNetworks/test-pre-vnet/subnets/my-k8s-subnet
  // tectonic_azure_external_master_subnet_id = ""


  // (optional) The ID of the external Network Security Group used for masters.
  // Leave blank to have a new one created.
  // 
  // Note this is the complete ID as returned in the "id" field by the Azure client, not just the name of the resource.
  // 
  // Example: "/subscriptions/b520eabf-d6c0-4757-8a5e-0fa7d2fe12b5/resourceGroups/my-k8s-cluster/providers/Microsoft.Network/networkSecurityGroups/my-master-nsg
  // tectonic_azure_external_nsg_master_id = ""


  // (optional) The ID of the external Network Security Group used for workers.
  // Leave blank to have a new one created.
  // 
  // Note this is the complete ID as returned in the "id" field by the Azure client, not just the name of the resource.
  // 
  // Example: "/subscriptions/b520eabf-d6c0-4757-8a5e-0fa7d2fe12b5/resourceGroups/my-k8s-cluster/providers/Microsoft.Network/networkSecurityGroups/my-worker-nsg
  // tectonic_azure_external_nsg_worker_id = ""


  // (optional) Name of an external resource group to place created resources in.
  // Leave blank to have a new one created.
  // tectonic_azure_external_resource_group = ""


  // (optional) Resource ID of an existing Virtual Network to launch nodes into.
  // Leave blank to create a new Virtual Network.
  // 
  // Note this is the complete ID as returned in the "id" field by the Azure client, not just the name of the resource.
  // 
  // Example: /subscriptions/b520eabf-d6c0-4757-8a5e-0fa7d2fe12b5/resourceGroups/my-k8s-cluster/providers/Microsoft.Network/virtualNetworks/my-k8s-vnet
  // tectonic_azure_external_vnet_id = ""


  // (optional) Subnet ID within an existing VNet to deploy worker nodes into.
  // Required to use an existing VNet.
  // 
  // Note this is the complete ID as returned in the "id" field by the Azure client, not just the name of the resource.
  // 
  // Example: "/subscriptions/b520eabf-d6c0-4757-8a5e-0fa7d2fe12b5/resourceGroups/my-k8s-cluster/providers/Microsoft.Network/virtualNetworks/test-pre-vnet/subnets/my-k8s-subnet
  // tectonic_azure_external_worker_subnet_id = ""


  // (optional) A map of extra Azure tags to be applied to created resources.
  // NOTE: Tags MUST NOT contain reserved characters '<,>,%,&,\,?,/' or control characters.
  // tectonic_azure_extra_tags = ""


  // (optional) Storage account type for the master node(s). Example: Premium_LRS.
  // Using Premium storage is constrained by the of instance specified in 'tectonic_azure_master_vm_size'.
  // See https://docs.microsoft.com/en-us/azure/storage/storage-premium-storage#supported-vms
  // tectonic_azure_master_storage_type = "Premium_LRS"


  // (optional) Instance size for the master node(s). Example: Standard_DS2_v2.
  // tectonic_azure_master_vm_size = "Standard_DS2_v2"


  // (optional) Setting this to true will result in NO public facing endpoints being created. All traffic is contained within the VNET.
  // A VNET with an already configured and active VPN connection is required and needs to be supplied via 'tectonic_azure_external_vnet_id'.
  // DNS is currently required, either the Azure managed one or configured via the generic DNS module.
  // tectonic_azure_private_cluster = false

  // (required) Path to an SSH public key file to be provisioned as the SSH key for the 'core' user.
  tectonic_azure_ssh_key = ""

  // (optional) Network (external) to allow SSH access from. Maps to `source_address_prefix` in Azure.
  // Defaults to `*`. Can be external to Azure environment.
  // Allowed values: [network CIDR (i.e., 10.0.0.0/16) \| `VirtualNetwork` \| `Internet` \| `*` ]
  // tectonic_azure_ssh_network_external = "*"


  // (optional) Network (internal) to allow SSH access from. Maps to `source_address_prefix` in Azure.
  // Defaults to `VirtualNetwork`. Should be internal to Azure environment.
  // Allowed values: [network CIDR (i.e., 10.0.0.0/16) \| `VirtualNetwork` \| `Internet` \| `*` ]
  // tectonic_azure_ssh_network_internal = "VirtualNetwork"


  // (optional) Range of IP addresses assigned to the Virtual Network in which the cluster nodes run.
  // This should not overlap with any other networks, such as the Kubernetes cluster (pod) range,
  // service range or a private datacenter connected via ExpressRoute."
  // tectonic_azure_vnet_cidr_block = "10.0.0.0/16"


  // (optional) Storage account type for the worker node(s). Example: Premium_LRS.
  // Using Premium storage is constrained by the of instance specified in 'tectonic_azure_worker_vm_size'.
  // See https://docs.microsoft.com/en-us/azure/storage/storage-premium-storage#supported-vms
  // tectonic_azure_worker_storage_type = "Premium_LRS"


  // (optional) Instance size for the worker node(s). Example: Standard_DS2_v2.
  // tectonic_azure_worker_vm_size = "Standard_DS2_v2"

  // The base DNS domain of the cluster. It must NOT contain a trailing period. Some
  // DNS providers will automatically add this if necessary.
  // 
  // Example: `openstack.dev.coreos.systems`.
  // 
  // Note: This field MUST be set manually prior to creating the cluster.
  // This applies only to cloud platforms.
  // 
  // [Azure-specific NOTE]
  // To use Azure-provided DNS, `tectonic_base_domain` should be set to `""`
  // If using DNS records, ensure that `tectonic_base_domain` is set to a properly configured external DNS zone.
  // Instructions for configuring delegated domains for Azure DNS can be found here: https://docs.microsoft.com/en-us/azure/dns/dns-delegate-domain-azure-dns
  tectonic_base_domain = ""

  // (optional) The content of the PEM-encoded CA certificate, used to generate Tectonic Console's server certificate.
  // If left blank, a CA certificate will be automatically generated.
  // tectonic_ca_cert = ""


  // (optional) The content of the PEM-encoded CA key, used to generate Tectonic Console's server certificate.
  // This field is mandatory if `tectonic_ca_cert` is set.
  // tectonic_ca_key = ""


  // (optional) The algorithm used to generate tectonic_ca_key.
  // The default value is currently recommended.
  // This field is mandatory if `tectonic_ca_cert` is set.
  // tectonic_ca_key_alg = "RSA"


  // (optional) This declares the IP range to assign Kubernetes pod IPs in CIDR notation.
  // tectonic_cluster_cidr = "10.2.0.0/16"

  // The name of the cluster.
  // If used in a cloud-environment, this will be prepended to `tectonic_base_domain` resulting in the URL to the Tectonic console.
  // 
  // Note: This field MUST be set manually prior to creating the cluster.
  // Warning: Special characters in the name like '.' may cause errors on OpenStack platforms due to resource name constraints.
  tectonic_cluster_name = ""

  // (optional) The Container Linux update channel.
  // 
  // Examples: `stable`, `beta`, `alpha`
  // tectonic_container_linux_channel = "stable"

  // The Container Linux version to use. Set to `latest` to select the latest available version for the selected update channel.
  // 
  // Examples: `latest`, `1465.6.0`
  tectonic_container_linux_version = "latest"

  // (optional) A list of PEM encoded CA files that will be installed in /etc/ssl/certs on etcd, master, and worker nodes.
  // tectonic_custom_ca_pem_list = ""


  // (optional) This only applies if you use the modules/dns/ddns module.
  // 
  // Specifies the RFC2136 Dynamic DNS server key algorithm.
  // tectonic_ddns_key_algorithm = ""


  // (optional) This only applies if you use the modules/dns/ddns module.
  // 
  // Specifies the RFC2136 Dynamic DNS server key name.
  // tectonic_ddns_key_name = ""


  // (optional) This only applies if you use the modules/dns/ddns module.
  // 
  // Specifies the RFC2136 Dynamic DNS server key secret.
  // tectonic_ddns_key_secret = ""


  // (optional) This only applies if you use the modules/dns/ddns module.
  // 
  // Specifies the RFC2136 Dynamic DNS server IP/host to register IP addresses to.
  // tectonic_ddns_server = ""


  // (optional) The size in MB of the PersistentVolume used for handling etcd backups.
  // tectonic_etcd_backup_size = "512"


  // (optional) The name of an existing Kubernetes StorageClass that will be used for handling etcd backups.
  // tectonic_etcd_backup_storage_class = ""


  // (optional) The path of the file containing the CA certificate for TLS communication with etcd.
  // 
  // Note: This works only when used in conjunction with an external etcd cluster.
  // If set, the variable `tectonic_etcd_servers` must also be set.
  // tectonic_etcd_ca_cert_path = "/dev/null"


  // (optional) The path of the file containing the client certificate for TLS communication with etcd.
  // 
  // Note: This works only when used in conjunction with an external etcd cluster.
  // If set, the variables `tectonic_etcd_servers`, `tectonic_etcd_ca_cert_path`, and `tectonic_etcd_client_key_path` must also be set.
  // tectonic_etcd_client_cert_path = "/dev/null"


  // (optional) The path of the file containing the client key for TLS communication with etcd.
  // 
  // Note: This works only when used in conjunction with an external etcd cluster.
  // If set, the variables `tectonic_etcd_servers`, `tectonic_etcd_ca_cert_path`, and `tectonic_etcd_client_cert_path` must also be set.
  // tectonic_etcd_client_key_path = "/dev/null"

  // The number of etcd nodes to be created.
  // If set to zero, the count of etcd nodes will be determined automatically.
  // 
  // Note: This is not supported on bare metal.
  tectonic_etcd_count = "0"

  // (optional) List of external etcd v3 servers to connect with (hostnames/IPs only).
  // Needs to be set if using an external etcd cluster.
  // Note: If this variable is defined, the installer will not create self-signed certs.
  // To provide a CA certificate to trust the etcd servers, set "tectonic_etcd_ca_cert_path".
  // 
  // Example: `["etcd1", "etcd2", "etcd3"]`
  // tectonic_etcd_servers = ""


  // (optional) If set to `true`, all etcd endpoints will be configured to use the "https" scheme.
  // 
  // Note: If `tectonic_experimental` is set to `true` this variable has no effect, because the experimental self-hosted etcd always uses TLS.
  // tectonic_etcd_tls_enabled = true

  // The path to the tectonic licence file.
  // You can download the Tectonic license file from your Account overview page at [1].
  // 
  // [1] https://account.coreos.com/overview
  // 
  // Note: This field MUST be set manually prior to creating the cluster unless `tectonic_vanilla_k8s` is set to `true`.
  tectonic_license_path = ""
  // The number of master nodes to be created.
  // This applies only to cloud platforms.
  tectonic_master_count = "1"

  // (optional) Configures the network to be used in Tectonic. One of the following values can be used:
  // 
  // - "flannel": enables overlay networking only. This is implemented by flannel using VXLAN.
  // 
  // - "canal": [ALPHA] enables overlay networking including network policy. Overlay is implemented by flannel using VXLAN. Network policy is implemented by Calico.
  // 
  // - "calico": [ALPHA] enables BGP based networking. Routing and network policy is implemented by Calico. Note this has been tested on baremetal installations only.
  // tectonic_networking = "flannel"

  // The path the pull secret file in JSON format.
  // This is known to be a "Docker pull secret" as produced by the docker login [1] command.
  // A sample JSON content is shown in [2].
  // You can download the pull secret from your Account overview page at [3].
  // 
  // [1] https://docs.docker.com/engine/reference/commandline/login/
  // 
  // [2] https://coreos.com/os/docs/latest/registry-authentication.html#manual-registry-auth-setup
  // 
  // [3] https://account.coreos.com/overview
  // 
  // Note: This field MUST be set manually prior to creating the cluster unless `tectonic_vanilla_k8s` is set to `true`.
  tectonic_pull_secret_path = ""

  // (optional) This declares the IP range to assign Kubernetes service cluster IPs in CIDR notation.
  // The maximum size of this IP range is /12
  // tectonic_service_cidr = "10.3.0.0/16"

  // Validity period of the self-signed certificates (in hours).
  // Default is 3 years.
  // This setting is ignored if user provided certificates are used.
  tectonic_tls_validity_period = "26280"
  // If set to true, a vanilla Kubernetes cluster will be deployed, omitting any Tectonic assets.
  tectonic_vanilla_k8s = false
  // The number of worker nodes to be created.
  // This applies only to cloud platforms.
  tectonic_worker_count = "3"
}
